###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mozilla_prdts_dos_vuln_jun09_win.nasl 3134 2009-06-30 18:49:33Z jun $
#
# Mozilla Products DoS Vulnerability June-09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900389);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2210");
  script_bugtraq_id(35461);
  script_name("Mozilla Products DoS Vulnerability June-09 (Win)");
  desc = "

  Overview: The host is installed with Thunderbird/Seamonkey and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  The flaw exists when application fails to handle user input messages via
  a multipart or alternative e-mail message containing a text or enhanced part
  that triggers access to an incorrect object type.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code via
  e-mail messages, and results in Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  Seamonkey version prior to 1.1.17 and
  Thunderbird version prior to 2.0.0.22 on Windows.

  Fix:
  Upgrade to Seamonkey version 1.1.17
  http://www.seamonkey-project.org/releases
  Upgrade to Thunderbird version 2.0.0.22
  http://www.mozillamessaging.com/en-US/thunderbird/all.html

  References:
  http://xforce.iss.net/xforce/xfdb/51315
  http://www.mozilla.org/security/announce/2009/mfsa2009-33.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Thunderbird/Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_seamonkey_detect_win.nasl",
                      "gb_thunderbird_detect_win.nasl");
  script_require_keys("Seamonkey/Win/Ver", "Thunderbird/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Win/Ver");
if(smVer != NULL)
{
  # Grep for Seamonkey version prior to 1.1.17
  if(version_is_less(version:smVer, test_version:"1.1.17")){
    security_hole(0);
    exit(0);
  }
}

# Thunderbird Check
tbVer = get_kb_item("Thunderbird/Win/Ver");
if(tbVer != NULL)
{
  # Grep for Thunderbird version prior to 2.0.0.22
  if(version_is_less(version:tbVer, test_version:"2.0.0.22")){
    security_hole(0);
  }
}
