/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef GLOBALS_H
#define GLOBALS_H

#include "qchatsettings.h"
#include "logwgt.h"

#include <QByteArray>
#include <QColor>
#include <QHostAddress>
#include <QString>
#include <QNetworkInterface>

#define DEBUG 0

class UserInfo;

// const unsigned short MAX_PACKET_LEN    = 10000;
const unsigned short MAX_PACKET_LEN    = 65535 - 1024;

//\*****************************************************************************
struct QC_DatagramHeader
{
  unsigned short     programVersion;
  unsigned short     protocolVersion;
  unsigned long long dest_ip;
  unsigned long long src_ip;
  unsigned char      type;  /// tip paketa(iz enum DataType)
  unsigned long      id;    /// id paketa(dlya fragmentirovannyh paketov),esli 0,to paket fragment odin
  unsigned long      num;   /// nomer paketa (pakety s dannymi nachinayutsya s 1(pervogo:) !!!
  unsigned long long tm;    /// vremya otpravki
  unsigned long long receive_tm;/// vremya polucheniya
  unsigned long      chnnl_id;///id kanala, v kotryi poslano soobsch. etc
  unsigned char      comp_name_len;
  unsigned char      name_len;
  unsigned long      msg_len;
  unsigned long      parametrs_len;
  QString            name;
  QString            comp_name;
  QString            msg;
  QString            versionName;
  QColor             color;
  quint16            status;
  QByteArray         parametrs;/// soderzhit razlichnye dopolnitel'nye parametry
  bool               isHtml;

  QC_DatagramHeader(){}

};
//*****************************************************************************

class Globals
{
  public:
    static const uint   VersionID;
    static const uint   Revision;
    static const char*  VersionsTable[15];
    static QString      VersionStr;
    static QString      StatusStr[7];

    static QString        m_profileName;
    static QChatSettings* m_settings;
    static UserInfo*      m_info;

    static LogWgt*      m_log;

    static void addMessage(const QString & str, const QColor & color = QColor(Qt::black))
    {if(m_log) m_log->addMessage(str, color);}
    static void addInfo   (const QString & str)
    {if(m_log) m_log->addInfo(str);}
    static void addError  (const QString & str)
    {if(m_log) m_log->addError(str);}

    Globals(){}
    ~Globals(){}

    static quint32 localIp(QHostAddress* br);
    static QList<QNetworkInterface> validInterfeices();

    static uint localhost(){if(QChatSettings::settings()->mode() == QChatSettings::Server) return 1; return 0x7f000001;}

    enum StatusID{BUSY = 0, FREE = 1, READY4CHAT = 2, DND = 3, INACTIVE = 4, AWAY = 5, INVISIBLE = 6};
};

bool isSystemMsg(quint16 type);
char* datadup(const char* src, int n);
unsigned long long str2ULL(const char* str);
unsigned long      str2UL (const char* str);
unsigned short     str2US (const char* str);
int catULL2str(char* str, unsigned long long num);
int catUL2str (char* str, unsigned long      num);
int catUS2str (char* str, unsigned short     num);

#endif
