/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "iplisteditor.h"

#include <QGridLayout>
#include <QHostAddress>

#include "qchatsettings.h"

IpListEditor::IpListEditor(QWidget *parent)
 : QWidget(parent)
{
  QGridLayout* grid    = new QGridLayout(this);
  QGridLayout* dlgGrid;

  m_useIpListChbx = new QCheckBox  (this);
  m_showEditorBtn = new QPushButton(this);
  m_ipListEdit    = new QTextEdit  (this);
  m_okBtn         = new QPushButton(this);
  m_cancelBtn     = new QPushButton(this);
  m_editorDlg     = new QDialog    (this);

  dlgGrid = new QGridLayout(m_editorDlg);

  dlgGrid->addWidget(m_ipListEdit, 0, 0, 3, 1);
  dlgGrid->addWidget(m_okBtn     , 0, 1);
  dlgGrid->addWidget(m_cancelBtn , 1, 1);
  dlgGrid->setMargin(0);

  m_editorDlg->hide();

  grid->addWidget(m_useIpListChbx, 0, 0);
  grid->addWidget(m_showEditorBtn, 0, 1);

  grid->setColumnStretch(0, 1);

  grid->setMargin(0);

  connect(m_showEditorBtn, SIGNAL(clicked()), this, SLOT(showEditor()));
  connect(m_okBtn        , SIGNAL(clicked()), this, SLOT(applyChanges()));
  connect(m_cancelBtn    , SIGNAL(clicked()), this, SLOT(discardChanges()));
  connect(m_useIpListChbx, SIGNAL(stateChanged(int)), this, SLOT(setUseIpList(int)));

  retranslate();
}

IpListEditor::~IpListEditor()
{
  qDebug("[~IpListEditor]");
}

void IpListEditor::retranslate()
{
  m_useIpListChbx->setText(tr("Use IP list instead of broadcasting"));
  m_showEditorBtn->setText(tr(".."));
  m_okBtn        ->setText(tr("Ok"));
  m_cancelBtn    ->setText(tr("Cancel"));

  m_showEditorBtn->setToolTip(tr("Edit IP List.."));
  m_ipListEdit   ->setToolTip(tr("Enter one IP per line"));

  m_editorDlg    ->setWindowTitle(tr("IP List Editor"));
}

void IpListEditor::showEditor()
{
  m_ipListEdit->clear();

  foreach(QHostAddress ip, QChatSettings::ipList())
    m_ipListEdit->append(ip.toString());

  m_editorDlg->show();
}

void IpListEditor::applyChanges()
{
  QStringList ipList = m_ipListEdit->toPlainText().split("\n");

  QChatSettings::clearIpList();

  foreach(QString ip, ipList)
  {
    if(QHostAddress(ip).toIPv4Address() != 0)
      QChatSettings::addIpListEntry(QHostAddress(ip));
  }

  m_editorDlg->accept();
}

void IpListEditor::discardChanges()
{
  m_editorDlg->reject();
}

void IpListEditor::setUseIpList(int checked)
{
  if(checked == Qt::Checked)
    QChatSettings::settings()->setOption("UseIPList", true);
  else
    QChatSettings::settings()->setOption("UseIPList", false);
}

void IpListEditor::init()
{
  m_useIpListChbx->setChecked(QChatSettings::settings()->boolOption("UseIPList"));
}
