/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "messagetreeitem.h"

#include "singlemsgshistorymodel.h"
#include "singlemessage.h"

#include "qchaticon.h"


MessageTreeItem::MessageTreeItem(const QList<QVariant> & data, TreeItem* parent, QString name):
  TreeItem(data, parent, name),
  m_message(NULL)
{
}

MessageTreeItem::~MessageTreeItem()
{
  qDebug("[~MessageTreeItem]");
}

void MessageTreeItem::sortChildren(int column, Qt::SortOrder order)
{
  setSortingColumn(column);
  setSortingOrder (order);

  foreach(TreeItem* item, *children())
    item->setSortingColumn(column);

  qStableSort(children()->begin(), children()->end(), MessageTreeItem::LessThan);

  foreach(TreeItem* item, *children())
    item->sortChildren(column, order);
}

bool MessageTreeItem::LessThan(TreeItem* item1, TreeItem* item2)
{
  bool res;

  MessageTreeItem* i1 = static_cast<MessageTreeItem*>(item1);
  MessageTreeItem* i2 = static_cast<MessageTreeItem*>(item2);

  if(i1 && i2 && i1->message() && i2->message())
  {
    switch(sortingColumn())
    {
       case SingleMsgsHistoryModel::DateCol :
         res = i1->message()->receiveTime() < i2->message()->receiveTime();
         break;

       case SingleMsgsHistoryModel::IpCol :
         res = i1->message()->srcIp() < i2->message()->srcIp();
         break;

       case SingleMsgsHistoryModel::NicknameCol :
         res = i1->message()->userName() < i2->message()->userName();
         break;

       case SingleMsgsHistoryModel::MessageCol :
         res = i1->message()->msg() < i2->message()->msg();
         break;

       default :
         res = (i1->data(sortingColumn(), Qt::DisplayRole).toString() <
                i2->data(sortingColumn(), Qt::DisplayRole).toString());
    }
  }
  else
    res = (i1->data(sortingColumn(), Qt::DisplayRole).toString() <
           i2->data(sortingColumn(), Qt::DisplayRole).toString());

  return sortingOrder() == Qt::AscendingOrder ? res : !res;
}


QVariant MessageTreeItem::data(int column, int role, bool with_hidden) const
{
  int visible_cols = visibleCols(with_hidden, Qt::DisplayRole);
  int real_column = realColumn(column);
  bool ok = visible_cols > column && column >= 0;

  if(real_column == 0 && role == Qt::DecorationRole)
  {
    if(ok && m_message && m_message->messageWgt())
      return QIcon(QChatIcon::icon( (m_message->isNew() ? "message-unread" : "message-opened")) );
    else
      return QVariant();
  }
  else
    return TreeItem::data(column, role, with_hidden);

  return QVariant();
}
