/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWQTNOQUTECOMALERT_H
#define OWQTNOQUTECOMALERT_H

#include <QtCore/QObject>

class QWidget;
class QDialog;
class QtQuteCom;

namespace Ui { class NoQuteComAlert; }

/**
 * Pop up Alert when user does not have a qutecom account
 *
 * @author Xavier Desjardins
 */
class QtNoQuteComAlert : public QObject {
	Q_OBJECT
public:

	QtNoQuteComAlert(QWidget * parent, QtQuteCom & qtQuteCom);

	QtNoQuteComAlert(QWidget * parent, QtQuteCom & qtQuteCom, QString title, QString maintext);

	~QtNoQuteComAlert();

	QDialog * getQDialog() const {
		return _NoQuteComAlert;
	}
	
	void setDialogText(QString newtext);
	
	void setTitle(QString newtitle);

private Q_SLOTS:

	void haveButtonClicked();

	void createButtonClicked();

private:

	Ui::NoQuteComAlert * _ui;

	QDialog * _NoQuteComAlert;
	
	QtQuteCom & _qtQuteCom;
};

#endif	//OWQTNOQUTECOMALERT_H
