/*
 *   This file is part of VBA Express.
 *
 *   Copyright (c) 2005-2006 Achraf cherti <achrafcherti@gmail.com>
 * 
 *   VBA Express is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   VBA Express is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with VBA Express; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

//============================================
// Voir spath.c pour plus de détails
// sur la licence et le fonctionnement 
// de la librairie.
//
// Auteur: Achraf cherti
// Email:  achrafcherti@gmail.com
//============================================
// Fichier source distribué en GPL v2
//============================================

#ifndef SPATH_H
#define SPATH_H

#ifdef __cplusplus
	extern "C" {
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

typedef struct {
	struct stat s;
	const char *filename;
} SP_STAT;

#ifdef WIN32
#define SLASH     "\\"
#define C_SLASH   '\\'
#define SLASH2    "/"
#define C_SLASH2  '/'
#else
#define SLASH     "/"
#define C_SLASH   '/'
#define SLASH2    "\\"
#define C_SLASH2  '\\'
#endif

#define isslash(s) (s==C_SLASH)
#define isslash2(s) (s==C_SLASH || s==C_SLASH2)

//paths
char *sp_executable_path(const char *argv0);
char *sp_pwd();
#ifdef WIN32
char *sp_pwd_drive(char drive);
#endif
char *sp_truepath(const char *path);
char *sp_dirname(char *path);
char *sp_extname(char *path);
const char *sp_extname_p(const char *path);
char *sp_basename(char *path);
const char *sp_basename_p(const char *path);
char *sp_pathcat(const char *path1, const char *path2);
char *sp_which(char *commande);

//fixation dans le path
char *sp_fix_slash_repeated(char *path);
char *sp_make_system_slash(char *path);
char *sp_fix_p_cdpp(char *path);

// pour lire des informations sur
// les fichiers
SP_STAT *sp_stat(const char *filename, SP_STAT *info);
int sp_isdir(SP_STAT *info);
int sp_isreg(SP_STAT *info);
int sp_isexec(SP_STAT *info);
int sp_file_exists(const char *filename);
int sp_exists(const char *filename);

#ifdef __cplusplus
	}
#endif

#endif

