/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLFontStyleNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseFontStyle
extends AbstractNode
implements VRMLFontStyleNodeType {
    private static final String MAJOR_JUSTIFY_ERR_MSG = "Invalid justify enumerant value for the major type: ";
    private static final String MINOR_JUSTIFY_ERR_MSG = "Invalid justify enumerant value for the minor type: ";
    private static final String FONT_SIZE_PROP = "org.web3d.vrml.nodes.fontstyle.font.size";
    private static final int DEFAULT_FONT_SIZE = 36;
    private static final int FONT_SIZE;
    private static final String DEFAULT_FAMILY = "SERIF";
    private static final String SERIF_FONT = "Serif";
    private static final String SANS_FONT = "SansSerif";
    private static final String TYPEWRITER_FONT = "Monospaced";
    protected static final int FIELD_FAMILY = 1;
    protected static final int FIELD_HORIZONTAL = 2;
    protected static final int FIELD_JUSTIFY = 3;
    protected static final int FIELD_LANGUAGE = 4;
    protected static final int FIELD_LEFTTORIGHT = 5;
    protected static final int FIELD_SIZE = 6;
    protected static final int FIELD_SPACING = 7;
    protected static final int FIELD_STYLE = 8;
    protected static final int FIELD_TOPTOBOTTOM = 9;
    protected static final int LAST_FONTSTYLE_INDEX = 9;
    protected static final int NUM_FIELDS = 10;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected static HashMap justifyMap;
    protected static HashMap styleMap;
    protected static HashMap fontMap;
    private static HashSet systemFontFamilies;
    private String[] vfFamily;
    private String selectedFamilyFont;
    private boolean vfHorizontal;
    private String[] vfJustify;
    private int horizontalJustification;
    private int verticalJustification;
    private String vfLanguage;
    private boolean vfLeftToRight;
    private float vfSize;
    private float vfSpacing;
    private String vfStyle;
    private boolean vfTopToBottom;
    private Font awtFont;

    public BaseFontStyle() {
        super("FontStyle");
        this.isDEF = false;
        this.inSetup = true;
        String string = (String)fontMap.get(DEFAULT_FAMILY);
        this.vfFamily = new String[]{DEFAULT_FAMILY};
        this.selectedFamilyFont = string;
        this.vfHorizontal = true;
        this.vfJustify = new String[]{"BEGIN", null};
        this.vfLeftToRight = true;
        this.vfSize = 1.0f;
        this.vfSpacing = 1.0f;
        this.vfStyle = "PLAIN";
        this.vfTopToBottom = true;
        this.verticalJustification = 1;
        this.horizontalJustification = 1;
    }

    public BaseFontStyle(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(1);
            if (vRMLFieldData.numElements != 0) {
                String[] stringArray = vRMLFieldData.stringArrayValue;
                if (stringArray.length != this.vfFamily.length) {
                    this.vfFamily = new String[stringArray.length];
                }
                for (int i = 0; i < vRMLFieldData.numElements; ++i) {
                    this.vfFamily[i] = stringArray[i];
                }
            }
            vRMLFieldData = vRMLNodeType.getFieldValue(2);
            this.vfHorizontal = vRMLFieldData.booleanValue;
            vRMLFieldData = vRMLNodeType.getFieldValue(3);
            this.vfJustify[0] = vRMLFieldData.stringArrayValue[0];
            this.vfJustify[1] = vRMLFieldData.stringArrayValue[1];
            vRMLFieldData = vRMLNodeType.getFieldValue(5);
            this.vfLeftToRight = vRMLFieldData.booleanValue;
            vRMLFieldData = vRMLNodeType.getFieldValue(6);
            this.vfSize = vRMLFieldData.floatValue;
            vRMLFieldData = vRMLNodeType.getFieldValue(7);
            this.vfSpacing = vRMLFieldData.floatValue;
            vRMLFieldData = vRMLNodeType.getFieldValue(8);
            this.vfStyle = vRMLFieldData.stringValue;
            vRMLFieldData = vRMLNodeType.getFieldValue(4);
            this.vfLanguage = vRMLFieldData.stringValue;
            vRMLFieldData = vRMLNodeType.getFieldValue(9);
            this.vfTopToBottom = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public Font getFont() {
        return this.awtFont;
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    public float getSpacing() {
        return this.vfSpacing;
    }

    public float getSize() {
        return this.vfSize;
    }

    public boolean isTopToBottom() {
        return this.vfTopToBottom;
    }

    public boolean isLeftToRight() {
        return this.vfLeftToRight;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        for (int i = 0; i < this.vfFamily.length; ++i) {
            if (systemFontFamilies.contains(this.vfFamily[i])) {
                this.selectedFamilyFont = this.vfFamily[i];
                break;
            }
            if (!fontMap.containsKey(this.vfFamily[i])) continue;
            this.selectedFamilyFont = (String)fontMap.get(this.vfFamily[i]);
            break;
        }
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, this.selectedFamilyFont);
        hashMap.put(TextAttribute.SIZE, new Float(this.vfSize * (float)FONT_SIZE));
        hashMap.put(TextAttribute.BACKGROUND, new Color(0, 0, 0, 1));
        if (this.vfLeftToRight) {
            hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
        } else {
            hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
        }
        Float f = TextAttribute.POSTURE_REGULAR;
        Float f2 = TextAttribute.WEIGHT_REGULAR;
        Integer n = (Integer)styleMap.get(this.vfStyle);
        if (n != null) {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    f = TextAttribute.POSTURE_REGULAR;
                    f2 = TextAttribute.WEIGHT_BOLD;
                    break;
                }
                case 2: {
                    f = TextAttribute.POSTURE_OBLIQUE;
                    f2 = TextAttribute.WEIGHT_REGULAR;
                    break;
                }
                case 3: {
                    f = TextAttribute.POSTURE_OBLIQUE;
                    f2 = TextAttribute.WEIGHT_BOLD;
                    break;
                }
            }
        }
        hashMap.put(TextAttribute.POSTURE, f);
        hashMap.put(TextAttribute.WEIGHT, f2);
        this.awtFont = new Font(hashMap);
        if (this.vfHorizontal) {
            Integer n2;
            if (this.vfJustify[0] != null) {
                n2 = (Integer)justifyMap.get(this.vfJustify[0]);
                this.horizontalJustification = n2;
            }
            if (this.vfJustify[1] != null) {
                n2 = (Integer)justifyMap.get(this.vfJustify[1]);
                this.verticalJustification = n2;
            }
        } else {
            Integer n3;
            if (this.vfJustify[1] != null) {
                n3 = (Integer)justifyMap.get(this.vfJustify[1]);
                this.horizontalJustification = n3;
            }
            if (this.vfJustify[0] != null) {
                n3 = (Integer)justifyMap.get(this.vfJustify[0]);
                this.verticalJustification = n3;
            }
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 9) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.stringArrayValue = this.vfFamily;
                vRMLFieldData.numElements = this.vfFamily.length;
                break;
            }
            case 2: {
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfHorizontal;
                break;
            }
            case 3: {
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.stringArrayValue = this.vfJustify;
                vRMLFieldData.numElements = this.vfJustify.length;
                break;
            }
            case 5: {
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfLeftToRight;
                break;
            }
            case 6: {
                vRMLFieldData.dataType = (short)4;
                vRMLFieldData.floatValue = this.vfSize;
                break;
            }
            case 7: {
                vRMLFieldData.dataType = (short)4;
                vRMLFieldData.floatValue = this.vfSpacing;
                break;
            }
            case 8: {
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfStyle;
                break;
            }
            case 4: {
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfLanguage;
                break;
            }
            case 9: {
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfTopToBottom;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public boolean hasFieldChanged(int n) {
        return false;
    }

    public int getPrimaryType() {
        return 19;
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("style", this);
                }
                this.vfStyle = string;
                break;
            }
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("language", this);
                }
                this.vfLanguage = string;
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("family", this);
                }
                this.vfFamily = stringArray;
                break;
            }
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("justify", this);
                }
                this.setJustify(stringArray);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("size", this);
                }
                this.vfSize = f;
                break;
            }
            case 7: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("spacing", this);
                }
                this.vfSpacing = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("leftToRight", this);
                }
                this.vfLeftToRight = bl;
                break;
            }
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("horizontal", this);
                }
                this.vfLeftToRight = bl;
                break;
            }
            case 9: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("topToBottom", this);
                }
                this.vfTopToBottom = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    private void setJustify(String[] stringArray) throws InvalidFieldValueException {
        switch (stringArray.length) {
            case 0: {
                this.vfJustify[0] = null;
                this.vfJustify[1] = null;
                break;
            }
            case 1: {
                if (justifyMap.get(stringArray[0]) == null) {
                    throw new InvalidFieldValueException(MAJOR_JUSTIFY_ERR_MSG + stringArray[0]);
                }
                this.vfJustify[0] = stringArray[0];
                this.vfJustify[1] = null;
                break;
            }
            default: {
                if (justifyMap.get(stringArray[0]) == null) {
                    throw new InvalidFieldValueException(MAJOR_JUSTIFY_ERR_MSG + stringArray[0]);
                }
                if (justifyMap.get(stringArray[1]) == null) {
                    throw new InvalidFieldValueException(MINOR_JUSTIFY_ERR_MSG + stringArray[1]);
                }
                this.vfJustify[0] = stringArray[0];
                this.vfJustify[1] = stringArray[1];
            }
        }
    }

    static {
        fieldDecl = new VRMLFieldDeclaration[10];
        fieldMap = new HashMap(10);
        BaseFontStyle.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseFontStyle.fieldDecl[1] = new VRMLFieldDeclaration(2, "MFString", "family");
        BaseFontStyle.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFBool", "horizontal");
        BaseFontStyle.fieldDecl[3] = new VRMLFieldDeclaration(2, "MFString", "justify");
        BaseFontStyle.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFString", "language");
        BaseFontStyle.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "leftToRight");
        BaseFontStyle.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFFloat", "size");
        BaseFontStyle.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFFloat", "spacing");
        BaseFontStyle.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFString", "style");
        BaseFontStyle.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFBool", "topToBottom");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("family", new Integer(1));
        fieldMap.put("horizontal", new Integer(2));
        fieldMap.put("justify", new Integer(3));
        fieldMap.put("language", new Integer(4));
        fieldMap.put("leftToRight", new Integer(5));
        fieldMap.put("size", new Integer(6));
        fieldMap.put("spacing", new Integer(7));
        fieldMap.put("style", new Integer(8));
        fieldMap.put("topToBottom", new Integer(9));
        justifyMap = new HashMap();
        justifyMap.put("BEGIN", new Integer(1));
        justifyMap.put("END", new Integer(2));
        justifyMap.put("MIDDLE", new Integer(3));
        justifyMap.put("FIRST", new Integer(4));
        styleMap = new HashMap();
        styleMap.put("BOLD", new Integer(1));
        styleMap.put("ITALIC", new Integer(2));
        styleMap.put("PLAIN", new Integer(0));
        styleMap.put("BOLDITALIC", new Integer(3));
        fontMap = new HashMap();
        fontMap.put(DEFAULT_FAMILY, SERIF_FONT);
        fontMap.put("SANS", SANS_FONT);
        fontMap.put("TYPEWRITER", TYPEWRITER_FONT);
        systemFontFamilies = new HashSet();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            systemFontFamilies.add(stringArray[i]);
        }
        Integer n2 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger(BaseFontStyle.FONT_SIZE_PROP, 36);
            }
        });
        int n3 = n2;
        if (n3 <= 0) {
            n3 = 36;
        }
        FONT_SIZE = n3;
    }
}

