/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointEditDialog;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class PointObject
extends ConstructionObject
implements MoveableObject {
    protected double X;
    protected double Y;
    protected double Alpha;
    protected boolean AlphaValid = false;
    protected boolean UseAlpha = false;
    protected boolean Moveable;
    protected boolean Fixed;
    private static Count N = new Count();
    protected int Type = 0;
    public static final int SQUARE = 0;
    public static final int DIAMOND = 1;
    public static final int CIRCLE = 2;
    public static final int DOT = 3;
    public static final int CROSS = 4;
    public static final int DCROSS = 5;
    public static int MaxType = 3;
    protected Expression EX;
    protected Expression EY;
    private ConstructionObject Bound = null;
    private boolean Later;
    private String LaterBind = "";
    private boolean KeepInside;
    private boolean DontUpdate = false;
    private double Increment = 0.0;
    protected ConstructionObject MovedBy;
    private double Delta;
    static double[] x = new double[4];
    static double[] y = new double[4];

    public PointObject(Construction construction, double d2, double d3) {
        super(construction);
        this.X = d2;
        this.Y = d3;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex);
        this.updateText();
        this.Type = 0;
    }

    public PointObject(Construction construction, double d2, double d3, ConstructionObject constructionObject) {
        this(construction, d2, d3);
        this.Bound = constructionObject;
    }

    public PointObject(Construction construction, String string) {
        super(construction, string);
        this.X = 0.0;
        this.Y = 0.0;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex);
        this.updateText();
        this.Type = 0;
    }

    public String getTag() {
        if (this.Bound == null) {
            return "Point";
        }
        return "PointOn";
    }

    public int getN() {
        return N.next();
    }

    public void setDefaults() {
        super.setDefaults();
        this.Type = this.Cn.DefaultType;
    }

    public double changedBy() {
        return this.Delta;
    }

    public void validate() {
        if (this.DontUpdate) {
            return;
        }
        this.MovedBy = null;
        this.Delta = 0.0;
        this.Valid = true;
        if (this.Bound != null && !this.Bound.isInConstruction()) {
            this.Bound = null;
        }
        if (this.Bound != null && !this.Bound.valid()) {
            this.Valid = false;
            return;
        }
        if (this.Increment > 1.0E-4) {
            this.X = Math.floor(this.X / this.Increment + 0.5) * this.Increment;
            this.Y = Math.floor(this.Y / this.Increment + 0.5) * this.Increment;
        }
        if (this.Bound != null) {
            double d2 = this.X;
            double d3 = this.Y;
            if (this.KeepInside && this.Bound instanceof InsideObject) {
                ((InsideObject)((Object)this.Bound)).keepInside(this);
            } else if (!this.KeepInside && this.Bound instanceof PointonObject) {
                if (!this.AlphaValid || !this.UseAlpha) {
                    this.project(this.Bound);
                } else {
                    this.project(this.Bound, this.Alpha);
                }
            }
            if (this.Later) {
                this.Delta = Math.sqrt((d2 - this.X) * (d2 - this.X) + (d3 - this.Y) * (d3 - this.Y));
            }
        }
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
    }

    public void updateText() {
        if (this.Bound != null) {
            this.setText(PointObject.text1(Zirkel.name("text.boundedpoint"), this.Bound.getName()));
        } else if (this.EX != null && this.EY != null) {
            this.setText(PointObject.text2(Zirkel.name("text.point"), "\"" + this.EX + "\"", "\"" + this.EY + "\""));
        } else {
            this.setText(PointObject.text2(Zirkel.name("text.point"), "" + this.round(this.X), "" + this.round(this.Y)));
        }
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        this.DisplaysText = false;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        double d2 = PointObject.drawPoint(myGraphics, zirkelCanvas, this, this.X, this.Y, this.Type);
        String string = AngleObject.translateToUnicode(this.getDisplayText());
        if (!string.equals("")) {
            myGraphics.setLabelColor(this);
            this.DisplaysText = true;
            this.setFont(myGraphics);
            double d3 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
            if (!this.KeepClose || d3 < 1.0E-10) {
                this.TX1 = zirkelCanvas.col(this.X + this.XcOffset) + 2.0 * d2;
                this.TY1 = zirkelCanvas.row(this.Y + this.YcOffset) + 2.0 * d2;
                this.drawLabel(myGraphics, string);
            } else {
                this.drawPointLabel(myGraphics, string, zirkelCanvas, this.X, this.Y, this.YcOffset / d3, -this.XcOffset / d3, 0.0, 0.0);
            }
        }
    }

    public static double drawPoint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject, double d2, double d3, int n) {
        double d4 = zirkelCanvas.pointSize();
        double d5 = zirkelCanvas.col(d2);
        double d6 = zirkelCanvas.row(d3);
        if (d4 < 1.0) {
            d4 = 1.0;
        }
        if (constructionObject.visible(zirkelCanvas)) {
            if (constructionObject.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                ((MyGraphics13)myGraphics).drawMarkerLine(d5, d6, d5, d6);
            }
            myGraphics.setColor(constructionObject);
            switch (n) {
                case 0: {
                    if (constructionObject.getColorType() == 1) {
                        myGraphics.fillRect(d5 - (d4 -= 1.0), d6 - d4, 2.0 * d4, 2.0 * d4, true, false, constructionObject);
                        break;
                    }
                    myGraphics.drawRect(d5 - d4, d6 - d4, 2.0 * d4, 2.0 * d4);
                    break;
                }
                case 1: {
                    d4 += 1.0;
                    if (constructionObject.getColorType() == 1) {
                        PointObject.x[0] = d5 - (d4 += 1.0);
                        PointObject.x[1] = d5;
                        PointObject.x[2] = d5 + d4;
                        PointObject.x[3] = d5;
                        PointObject.y[0] = d6;
                        PointObject.y[1] = d6 - d4;
                        PointObject.y[2] = d6;
                        PointObject.y[3] = d6 + d4;
                        myGraphics.fillPolygon(x, y, 4, false, false, constructionObject);
                        break;
                    }
                    myGraphics.drawLine(d5 - d4, d6, d5, d6 + d4);
                    myGraphics.drawLine(d5 - d4, d6, d5, d6 - d4);
                    myGraphics.drawLine(d5 + d4, d6, d5, d6 + d4);
                    myGraphics.drawLine(d5 + d4, d6, d5, d6 - d4);
                    break;
                }
                case 2: {
                    if (constructionObject.getColorType() == 1) {
                        myGraphics.fillOval(d5 - d4 - 1.0, d6 - d4 - 1.0, 2.0 * d4 + 2.0, 2.0 * d4 + 2.0, true, false, constructionObject);
                        break;
                    }
                    myGraphics.drawOval(d5 - d4, d6 - d4, 2.0 * d4, 2.0 * d4);
                    break;
                }
                case 3: {
                    if (constructionObject.getColorType() == 1) {
                        myGraphics.fillRect(d5, d6, 1.0, 1.0, true, false, constructionObject);
                        break;
                    }
                    myGraphics.drawLine(d5, d6, d5, d6);
                    break;
                }
                case 4: {
                    if (constructionObject.getColorType() == 1) {
                        myGraphics.drawThickLine(d5 - d4, d6, d5 + d4, d6);
                        myGraphics.drawThickLine(d5, d6 - d4, d5, d6 + d4);
                        break;
                    }
                    myGraphics.drawLine(d5 - d4, d6, d5 + d4, d6);
                    myGraphics.drawLine(d5, d6 - d4, d5, d6 + d4);
                    break;
                }
                case 5: {
                    if (constructionObject.getColorType() == 1) {
                        myGraphics.drawThickLine(d5 - d4, d6 - d4, d5 + d4, d6 + d4);
                        myGraphics.drawThickLine(d5 + d4, d6 - d4, d5 - d4, d6 + d4);
                        break;
                    }
                    myGraphics.drawLine(d5 - d4, d6 - d4, d5 + d4, d6 + d4);
                    myGraphics.drawLine(d5 + d4, d6 - d4, d5 - d4, d6 + d4);
                }
            }
        }
        return d4;
    }

    public String getDisplayValue() {
        return "(" + this.roundDisplay(this.X) + (Global.getParameter("options.germanpoints", false) ? "|" : ",") + this.roundDisplay(this.Y) + ")";
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        double d2 = zirkelCanvas.col(this.X);
        double d3 = zirkelCanvas.row(this.Y);
        int n3 = (int)zirkelCanvas.selectionSize();
        this.Value = Math.abs((double)n - d2) + Math.abs((double)n2 - d3);
        return this.Value <= (double)(n3 * 3 / 2);
    }

    public boolean nearto(PointObject pointObject) {
        if (!this.Valid) {
            return false;
        }
        double d2 = pointObject.X - this.X;
        double d3 = pointObject.Y - this.Y;
        return Math.sqrt(d2 * d2 + d3 * d3) < 1.0E-9;
    }

    public double distanceTo(int n, int n2, ZirkelCanvas zirkelCanvas) {
        double d2 = (double)n - zirkelCanvas.col(this.X);
        double d3 = (double)n2 - zirkelCanvas.row(this.Y);
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public boolean moveable() {
        boolean bl = this.Fixed;
        if (this.dependsOnItselfOnly()) {
            bl = false;
        }
        return this.Moveable && !bl && !this.Keep;
    }

    public boolean dependsOnItselfOnly() {
        boolean bl = false;
        Enumeration enumeration = this.depending();
        while (enumeration.hasMoreElements()) {
            if ((ConstructionObject)enumeration.nextElement() != this) continue;
            bl = true;
            break;
        }
        enumeration = this.depending();
        while (enumeration.hasMoreElements()) {
            if ((ConstructionObject)enumeration.nextElement() == this) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean dependsOnParametersOnly() {
        Enumeration enumeration = this.depending();
        while (enumeration.hasMoreElements()) {
            if (((ConstructionObject)enumeration.nextElement()).isParameter()) continue;
            return false;
        }
        return true;
    }

    public boolean moveableBy(ConstructionObject constructionObject) {
        if (this.Bound != null) {
            return false;
        }
        return this.moveable() && (this.MovedBy == null || this.MovedBy == constructionObject);
    }

    public boolean moveablePoint() {
        if (this.Bound != null) {
            return true;
        }
        return this.Moveable && !this.Keep;
    }

    public boolean setBound(String string) {
        block6: {
            if (string.equals("")) {
                this.Bound = null;
                this.setFixed(false);
                this.Later = false;
                return true;
            }
            try {
                this.Bound = null;
                ConstructionObject constructionObject = this.Cn.find(string);
                if (constructionObject instanceof PointonObject) {
                    this.Bound = constructionObject;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = false;
                    break block6;
                }
                if (constructionObject instanceof InsideObject) {
                    this.Bound = constructionObject;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = true;
                    break block6;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.Cn.before(this, this.Bound)) {
            this.Cn.needsOrdering();
            this.Cn.dovalidate();
        }
        this.updateText();
        return true;
    }

    public void setBound(ConstructionObject constructionObject) {
        this.Bound = constructionObject;
    }

    public ConstructionObject getBound() {
        return this.Bound;
    }

    public void setMoveable(boolean bl) {
        this.Moveable = bl;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean bl) {
        this.Fixed = bl;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    public void setFixed(String string, String string2) {
        this.Fixed = true;
        this.EX = new Expression(string, this.getConstruction(), this);
        this.EY = new Expression(string2, this.getConstruction(), this);
        this.updateText();
    }

    public void move(double d2, double d3) {
        this.X = d2;
        this.Y = d3;
        this.AlphaValid = false;
    }

    public void setXY(double d2, double d3) {
        this.X = d2;
        this.Y = d3;
    }

    public void setA(double d2) {
        this.Alpha = d2;
    }

    public void project(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof PointonObject)) {
            return;
        }
        ((PointonObject)((Object)constructionObject)).project(this);
        if (this.UseAlpha) {
            this.AlphaValid = true;
        }
    }

    public void project(ConstructionObject constructionObject, double d2) {
        ((PointonObject)((Object)constructionObject)).project(this, d2);
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        PointEditDialog pointEditDialog = new PointEditDialog(zirkelCanvas, this);
        pointEditDialog.setVisible(true);
        zirkelCanvas.repaint();
        if (this.EX != null && !this.EX.isValid()) {
            Frame frame = zirkelCanvas.getFrame();
            Warning warning = new Warning(frame, this.EX.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        } else if (this.EY != null && !this.EY.isValid()) {
            Frame frame = zirkelCanvas.getFrame();
            Warning warning = new Warning(frame, this.EY.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        this.validate();
        if (pointEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        this.updateText();
        if (this.Bound != null) {
            xmlWriter.printArg("on", this.Bound.getName());
            if (this.KeepInside) {
                xmlWriter.printArg("inside", "true");
            }
        }
        if (this.Fixed && this.EX != null) {
            xmlWriter.printArg("x", this.EX.toString());
            xmlWriter.printArg("actx", "" + this.X);
        } else {
            if (this.Bound != null && this.AlphaValid && this.UseAlpha) {
                xmlWriter.printArg("alpha", "" + this.Alpha);
            }
            xmlWriter.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null) {
            xmlWriter.printArg("y", this.EY.toString());
            xmlWriter.printArg("acty", "" + this.Y);
        } else {
            xmlWriter.printArg("y", "" + this.Y);
        }
        this.printType(xmlWriter);
        if (this.Fixed) {
            xmlWriter.printArg("fixed", "true");
        }
        if (this.Increment > 1.0E-4) {
            xmlWriter.printArg("increment", "" + this.getIncrement());
        }
    }

    public void printType(XmlWriter xmlWriter) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xmlWriter.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xmlWriter.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xmlWriter.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xmlWriter.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xmlWriter.printArg("shape", "dcross");
                }
            }
        }
    }

    public int getType() {
        return this.Type;
    }

    public void setType(int n) {
        this.Type = n;
    }

    public void movedBy(ConstructionObject constructionObject) {
        this.MovedBy = constructionObject;
    }

    public boolean equals(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof PointObject) || !constructionObject.valid()) {
            return false;
        }
        PointObject pointObject = (PointObject)constructionObject;
        return this.equals(this.X, pointObject.X) && this.equals(this.Y, pointObject.Y);
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public boolean isOn(ConstructionObject constructionObject) {
        if (this.Bound != null) {
            return constructionObject == this.Bound;
        }
        return constructionObject.contains(this);
    }

    public void translate() {
        if (this.Bound != null) {
            this.Bound = this.Bound.getTranslation();
        } else if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Enumeration depending() {
        super.depending();
        if (this.Bound != null) {
            DL.add(this.Bound);
        }
        if (this.Fixed) {
            if (this.EX != null) {
                this.EX.addDep(this);
            }
            if (this.EY != null) {
                this.EY.addDep(this);
            }
        }
        return DL.elements();
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
        this.updateText();
    }

    public void updateCircleDep() {
        if (this.Bound != null && this.Bound instanceof PrimitiveCircleObject) {
            ((PrimitiveCircleObject)this.Bound).addDep(this);
        }
        if (this.Bound != null && this.Bound instanceof PrimitiveLineObject) {
            ((PrimitiveLineObject)this.Bound).addDep(this);
        }
    }

    public boolean isPointOn() {
        return this.Bound != null;
    }

    public void setLaterBind(String string) {
        this.LaterBind = string;
    }

    public void setInside(boolean bl) {
        this.KeepInside = bl;
    }

    public boolean isInside() {
        return this.KeepInside;
    }

    public void laterBind(Construction construction) {
        if (this.LaterBind.equals("")) {
            return;
        }
        ConstructionObject constructionObject = construction.find(this.LaterBind);
        if (constructionObject != null && (constructionObject instanceof PointonObject || constructionObject instanceof InsideObject)) {
            this.Bound = constructionObject;
            this.updateText();
            this.validate();
        }
        this.LaterBind = "";
    }

    public void setAlpha(double d2) {
        this.Alpha = d2;
        this.AlphaValid = true;
    }

    public void setUseAlpha(boolean bl) {
        this.UseAlpha = bl;
    }

    public boolean useAlpha() {
        return this.UseAlpha;
    }

    public double getAlpha() {
        return this.Alpha;
    }

    public void round() {
        this.move(this.round(this.X, ZirkelCanvas.LengthsFactor), this.round(this.Y, ZirkelCanvas.LengthsFactor));
    }

    public void setKeepClose(double d2, double d3) {
        this.KeepClose = true;
        this.XcOffset = d2 - this.X;
        this.YcOffset = d3 - this.Y;
    }

    public boolean canKeepClose() {
        return true;
    }

    public boolean dontUpdate() {
        return this.DontUpdate;
    }

    public void dontUpdate(boolean bl) {
        this.DontUpdate = bl;
    }

    public void setTargetDefaults() {
        super.setTargetDefaults();
        this.Type = this.Cn.DefaultType;
    }

    public void startDrag(double d2, double d3) {
    }

    public void dragTo(double d2, double d3) {
        this.move(d2, d3);
    }

    public void setIncrement(double d2) {
        this.Increment = d2;
    }

    public double getIncrement() {
        return this.Increment;
    }
}

