subroutine fil3c(c1,n1,c2,n2)

! FIR complex-to-complex low-pass filter designed with ScopeFIR
!
!-----------------------------------------------
! fsample    (Hz)  12000      Input sample rate
! Ntaps            113        Number of filter taps
! fc         (Hz)  500        Cutoff frequency
! fstop      (Hz)  750        Lower limit of stopband
! Ripple     (dB)  0.2        Ripple in passband
! Stop Atten (dB)  50         Stopband attenuation
! fout       (Hz)  1500       Output sample rate

! Suggest calling with n1 = 8*n2 + 105, where n2 is the desired number
! of 1500 Hz output samples.

  parameter (NTAPS=113)
  parameter (NH=NTAPS/2)
  parameter (NDOWN=8)                !Downsample ratio = 1/8
  complex c1(n1)
  complex c2(n1/NDOWN)
  complex z

! Filter coefficients:
  real a(-NH:NH)
  data a/                                                               &
      -0.001818142144,-0.000939132050,-0.001044063556,-0.001042685542,  &
      -0.000908957610,-0.000628132309,-0.000202701465, 0.000346307629,  &
       0.000978154552, 0.001634336295, 0.002243121592, 0.002726064379,  &
       0.003006201675, 0.003018055983, 0.002717699575, 0.002091546534,  &
       0.001162489032,-0.000007904811,-0.001321554806,-0.002649908053,  &
      -0.003843608784,-0.004747338068,-0.005218967042,-0.005148229529,  &
      -0.004470167307,-0.003177923811,-0.001335998901, 0.000915924193,  &
       0.003386100636, 0.005818719744, 0.007939147967, 0.009465071347,  &
       0.010145641899, 0.009787447819, 0.008285915754, 0.005645995244,  &
       0.001995842303,-0.002410369720,-0.007202515555,-0.011916811719,  &
      -0.016028350845,-0.018993391440,-0.020297455955,-0.019503792208,  &
      -0.016298136197,-0.010526834635,-0.002223837363, 0.008378305829,  &
       0.020854478160, 0.034608532659, 0.048909701463, 0.062944127288,  &
       0.075874892030, 0.086903764340, 0.095332017649, 0.100619428175,  &
       0.102420526192, 0.100619428175, 0.095332017649, 0.086903764340,  &
       0.075874892030, 0.062944127288, 0.048909701463, 0.034608532659,  &
       0.020854478160, 0.008378305829,-0.002223837363,-0.010526834635,  &
      -0.016298136197,-0.019503792208,-0.020297455955,-0.018993391440,  &
      -0.016028350845,-0.011916811719,-0.007202515555,-0.002410369720,  &
       0.001995842303, 0.005645995244, 0.008285915754, 0.009787447819,  &
       0.010145641899, 0.009465071347, 0.007939147967, 0.005818719744,  &
       0.003386100636, 0.000915924193,-0.001335998901,-0.003177923811,  &
      -0.004470167307,-0.005148229529,-0.005218967042,-0.004747338068,  &
      -0.003843608784,-0.002649908053,-0.001321554806,-0.000007904811,  &
       0.001162489032, 0.002091546534, 0.002717699575, 0.003018055983,  &
       0.003006201675, 0.002726064379, 0.002243121592, 0.001634336295,  &
       0.000978154552, 0.000346307629,-0.000202701465,-0.000628132309,  &
      -0.000908957610,-0.001042685542,-0.001044063556,-0.000939132050,  &
      -0.001818142144/
  save a

  n2=(n1-NTAPS+NDOWN)/NDOWN
  k0=NH-NDOWN+1

! Loop over all output samples
  do i=1,n2
     z=0.
     k=k0 + NDOWN*i
     do j=-NH,NH
        z=z + c1(j+k)*a(j)
     enddo
     c2(i)=z
  enddo

  return
end subroutine fil3c
