/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _GLOBALS_H
#define _GLOBALS_H

#include <stdio.h>
#include "types.h"

/*
 * CLOCK_REFRESH controls whether or not YICS will refresh the board after a
 * clock update comes in.  Yahoo! appears to have moved the clock update to
 * before the board update, so this shouldn't be necessary anymore.
 */
#define CLOCK_REFRESH 0

/*
 * STEALTH controls whether or not the client will ignore "/ytoics" and "/yics"
 * ident requests.
 */
#define STEALTH 0

/*
 * SEE_IDENT controls whether or not you see "/ytoics" and "/yics" ident
 * requests.
 */
#if !STEALTH
# define SEE_IDENT 0
#endif

#define PROVISIONAL (-32768)

extern long int session;
extern char handle[256];
extern bool login_complete;
extern FILE *netlog;
extern Player *pme, *lasttell, *lastopp;
extern Player *players[PLAYER_MAX];
extern Option *clientOptions;
extern Table *tables[TABLE_MAX + 1];
extern int primary;
extern Invite *invitations;
extern char s_buffer[4096];

extern time_t lastcommand;

extern Player *findPlayer(const char *);
extern Player *completeHandle(String *);
extern Table *findTable(String *text, String *resolved);
extern String *realHandle(String *);
extern void observing(Table **, const Player *);

extern void addInvite(Player *, uchar, InviteType);
extern bool delInvite(Player *, uchar);
extern void destroyInvite(void);

#define prating(s,r,w) \
	if ((r) == PROVISIONAL) {\
		strcpy((s), "----"); \
	} else { \
		sprintf((s), "%*d", (w), (r));\
	}

#define tabletime(t)	(findOptionLong((t)->options, "tt") / 60000)
#define tableinc(t)	(findOptionLong((t)->options, "it") / 1000)
#define tablerated(t)	(findOption((t)->options, "rd") != NULL)
#endif
